#-*- coding: utf-8 -*-
from kivy.config import Config
Config.set('graphics', 'width', '1024')
Config.set('graphics', 'height', '768')

from kivy.app import App
from kivy.clock import Clock
from kivy.uix.widget import Widget
from kivy.properties import StringProperty
from kivy.core.text import LabelBase, DEFAULT_FONT
from kivy.resources import resource_add_path
import pyautogui as pg
import os
import re
from glob import glob
from random import randint

#日本語が使用できるように日本語フォントを指定する
resource_add_path('C:\Windows\Fonts')
LabelBase.register(DEFAULT_FONT, 'meiryo.ttc')

resource_add_path('./images')


class ImageViewer(Widget):

    b_slideshow = False # True:スライドショー、False:画像固定
    event = None
    source = StringProperty("./default.jpg")

    def __init__(self, **kwargs):
        super(ImageViewer, self).__init__(**kwargs)

        self.dir = r"./images/"
        self.filenames = []
        for filename in glob(self.dir + '*.*'):
            f = os.path.basename(filename)
            if re.search(r'jpg|jpeg|png', f):
                self.filenames.append(filename)

        if len(self.filenames) == 0:
            pg.alert(text='画像ファイルが存在しません', button='OK')
            exit()

        self.source= self.filenames[0]
        self.current_pict = 0
        self.ViewModeToggle()


    def ViewModeToggle(self):
        if self.b_slideshow == False:
            self.b_slideshow = True
            self.event = Clock.schedule_interval(self.RandomPictureSchedule, 2.0)
            if self.ids.items():
                self.ids["button1"].text = '画像を固定する'
        else:
            self.b_slideshow = False
            self.event.cancel()
            if self.ids.items():
                self.ids["button1"].text = 'スライドショー'

    def RandomPictureSchedule(self, dt):
        self.RandomPicture()

    def RandomPicture(self):
        n = len(self.filenames)
        if n != 1:
            while True:
                i = randint(0, n-1)
                if i != self.current_pict:  # 違う画像になるまでループで回す
                    self.current_pict = i
                    break
        self.source = self.filenames[i]


class MyKivyApp(App):
    def __init__(self, **kwargs):
        super(MyKivyApp, self).__init__(**kwargs)
        self.title = 'Photo Viewer'


if __name__ == '__main__':
    MyKivyApp().run()
