import cv2
import mediapipe as mp
import time

mpDraw = mp.solutions.drawing_utils
mpFaceMesh = mp.solutions.face_mesh
faceMesh = mpFaceMesh.FaceMesh(max_num_faces=1)
drawSpec = mpDraw.DrawingSpec(thickness=1, circle_radius=2)

img = cv2.imread('face.png')
imgRGB = cv2.cvtColor(img, cv2.COLOR_BGR2RGB)

results = faceMesh.process(imgRGB)
if results.multi_face_landmarks:
    for i in range(0, 10):
        img_copy = img.copy()
        for faceLms in results.multi_face_landmarks:
            mpDraw.draw_landmarks(img_copy, faceLms, mpFaceMesh.FACEMESH_CONTOURS,
                                  drawSpec, drawSpec)
            for id,lm in enumerate(faceLms.landmark):
                if id % 10 == i:
                    ih, iw, ic = img_copy.shape
                    x, y = int(lm.x*iw), int(lm.y*ih)
                    cv2.putText(img_copy, str(id), (x, y), cv2.FONT_HERSHEY_SIMPLEX, 0.5, (0, 0, 0), 1)

            cv2.imwrite(f'face_landmarks_{i}.png', img_copy)
