import os
import cv2
import mediapipe as mp
import time

cap = cv2.VideoCapture("sample1.mp4")
pTime = 0

mpDraw = mp.solutions.drawing_utils
mpFaceMesh = mp.solutions.face_mesh
faceMesh = mpFaceMesh.FaceMesh(max_num_faces=5)
drawSpec = mpDraw.DrawingSpec(color=(255, 255, 255), thickness=1, circle_radius=3)

while True:
    success, img = cap.read()
    if success == False:
        break
    imgRGB = cv2.cvtColor(img, cv2.COLOR_BGR2RGB)
    results = faceMesh.process(imgRGB)
    if results.multi_face_landmarks:
        for faceLms in results.multi_face_landmarks:
            mpDraw.draw_landmarks(img, faceLms, mpFaceMesh.FACEMESH_CONTOURS,
                                  drawSpec,drawSpec)

    cv2.imshow("Image", img)

    # FPS=30
    cTime = time.time()
    wait = int(33.3 - (cTime - pTime) * 1000)
    pTime = cTime
    if wait > 0:
        cv2.waitKey(wait)
    else:
        cv2.waitKey(1)
