import smtplib, ssl
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart
from email.mime.image import MIMEImage
import io
import os
import re
import sys
import base64
import datetime
from PIL import Image
from glob import glob


def sendmail_multifiles(filenames):
    
    # send from
    account = "XXXXX@ABC.com"
    password = "########"
     
    # send to
    to_email = "YYYYY@XYZ.com"
    from_email = " XXXXX@ABC.com "

    # e-mail header
    subject = "webcam:" + str(datetime.datetime.now())
    message = ""
    msg = MIMEMultipart("related")
    msg['Subject'] = subject
    msg["To"] = to_email
    msg["From"] = from_email
    msg.add_header('Content-Type','text/html')

    # open image files and attach them to the e-mail
    for filename in filenames:
        with open(filename, 'rb') as fp:
            f = os.path.basename(filename)
            img = MIMEImage(fp.read())
            img.add_header('Content-ID', '<{}>'.format(filename))
            img.add_header('Content-Disposition', 'inline', filename=f)
            msg.attach(img)

    server = smtplib.SMTP_SSL("smtp.gmail.com", 465, context=ssl.create_default_context())
    server.login(account, password)
    server.send_message(msg)
    server.quit()


def main():
    dir = r"/var/motion/"

    # check image files in the directory
    filenames = []
    for filename in glob(dir + '*.*'):
        f = os.path.basename(filename)
        if re.search(r'jpg|jpeg|png', f):
            filenames.append(filename)

    # send a mail with image files
    if filenames:
        sendmail_multifiles(filenames)

    # remove image files
    for f in filenames:
        os.remove(f)

if __name__ == "__main__":
    main()

