import shutil
from selenium import webdriver
from selenium.webdriver.chrome.options import Options
from webdriver_manager.chrome import ChromeDriverManager
from bs4 import BeautifulSoup
import requests
import time


class InstagramImgDownloader:

    def __init__(self):
        options = Options()
        options.add_argument("--headless") # ブラウザを起動したくない場合
        self.driver = webdriver.Chrome(ChromeDriverManager().install(), options=options)  # ChromeDriverの起動
        self.img_cnt = 1

    def get_image(self, URL):
        self.driver.get(URL)
        time.sleep(2)
        soup = BeautifulSoup(self.driver.page_source, "html.parser")
        
        try:
            for image in soup.find_all('img', class_='FFVAD'):   # class名を指定して、画像タグを取得する
                filename = "img_" + str(self.img_cnt) + ".jpg"   # 保存するファイル名
                image_link = image['src']                        # 画像のURL
                response = requests.get(image_link, stream=True) # 画像を取得する
                with open(filename, "wb") as file:               # 画像を保存する
                    shutil.copyfileobj(response.raw, file)
                self.img_cnt += 1
                break   # 最初の画像だけをダウンロードする
                
        except Exception as e:
            print(e)
            print(str(self.img_cnt)+"番目の画像のダウンロードができませんでした。")
            print("画像のリンク：" + image_link)



if __name__ == '__main__':
    URLs = ["https://www.instagram.com/p/CSzqOguCWzS/", 
            "https://www.instagram.com/p/CSwI5Smixfi/", 
            "https://www.instagram.com/p/CSbhHv6CU1J/", 
            "https://www.instagram.com/p/CSgw2oAiZQb/", 
            "https://www.instagram.com/p/CSaE7LAiDsy/", 
            "https://www.instagram.com/p/CSP1uy4iMiD/", 
            "https://www.instagram.com/p/CSSfTMhiXcQ/", 
            "https://www.instagram.com/p/CRvvLfnqtTg/", 
            "https://www.instagram.com/p/CQ_HiZpqaLj/", 
            "https://www.instagram.com/p/CPZBuI2HPWr/"]
    insta = InstagramImgDownloader()
    for URL in URLs:
        insta.get_image(URL)
