import subprocess
import csv
import os
import tkinter as tk
import tkinter.filedialog as fd
import tkinter.ttk as ttk
from tkinter import messagebox

###############################################################################
#
#   クラス定義
#
###############################################################################
class ShrinkMovie():
    
    def run(self):
        self.root.mainloop()

    #-------------------------------------------------------------------------#

    def __init__(self):

        self.root = tk.Tk()
        self.root.title(u"動画圧縮")
        self.root.geometry("320x100")

        # 入力フォーマット
        self.label1 = ttk.Label(self.root, text="入力フォーマット")
        self.label1.grid(row=1, column=0, padx=5, pady=5)
        format_in = ("mp4", "wmv", "avi", "すべて")
        self.comb_format_in = ttk.Combobox(self.root, values=format_in, height=4, width=7, state="readonly", justify="center")
        self.comb_format_in.current(0)
        self.comb_format_in.grid(row=1, column=1, padx=5, pady=5)

        # 圧縮率
        self.label3 = ttk.Label(self.root, text="圧縮率")
        self.label3.grid(row=2, column=0, padx=5, pady=5)
        comp_rate = ("高", "低")
        self.comb_comp_rate = ttk.Combobox(self.root, values=comp_rate, height=2, width=5, state="readonly", justify="center")
        self.comb_comp_rate.current(0)
        self.comb_comp_rate.grid(row=2, column=1, padx=5, pady=5)

        self.sep = ttk.Separator(self.root, orient="horizontal", style="blue.TSeparator")
        self.sep.grid(row=4, column=0, columnspan=2, sticky="ew")

        self.button_mov = tk.Button(self.root, text="圧縮処理", width=20, command=self.shrink_mov_files)
        self.button_mov.grid(row=6, column=0, padx=5, pady=5)

        self.button_exit = tk.Button(self.root, text="終了", width=20, command=self.exit_program)
        self.button_exit.grid(row=6, column=1, padx=5, pady=5)


    #-------------------------------------------------------------------------#

    def exit_program(self):
        
        self.root.quit()
        exit()

    #-------------------------------------------------------------------------#

    def ask_input_filenames(self, msg = None, types = [('', '*.*')]):
        """
        入力用ファイル名の設定
        """
        rt = tk.Tk()
        rt.withdraw()
        filenames = fd.askopenfilenames(title = msg, filetypes = types)
        rt.destroy()
        return filenames

    #-------------------------------------------------------------------------#

    def shrink_mov_files(self):

        # 入力ファイルの選択
        frm_in = self.comb_format_in.current()
        if frm_in == 0:
            frm_str = '*.mp4'
        elif frm_in == 1:
            frm_str = '*.wmv'
        elif frm_in == 2:
            frm_str = '*.avi'
        else:
            frm_str = '*.*'
        filepaths = self.ask_input_filenames("動画ファイルを選んでください", types=[('', frm_str)])

        # キャンセルされた場合
        if filepaths == '':
            return

        # 圧縮率の取得
        # Constant Rate Factor（CRF）：0～51の値を取り、値が大きくなるほど圧縮率が高くなる（画質が低下する）
        cmp_rate = self.comb_comp_rate.current()
        if cmp_rate == 0:
            crf = 28
        else:#if cmp_rate == 1:
            crf = 23

        for input_file in filepaths:

            try:
                dirname = os.path.dirname(input_file)
                base_filename = os.path.splitext(os.path.basename(input_file))[0] # 拡張子なしの入力ファイル名
                output_file = os.path.join(dirname, base_filename + "_圧縮.mp4")
                subprocess.call(f'ffmpeg -i "{input_file}" -c:a copy -c:v libx265 -crf {crf} "{output_file}"')
            
            except Exception as e:
                print(e.args)
                messagebox.showinfo("動画ファイル圧縮エラー", "動画ファイル圧縮中にエラーが発生しました。")
                return

        messagebox.showinfo("動画ファイル圧縮終了", "動画ファイルの圧縮が終わりました。")

    #-------------------------------------------------------------------------#



###############################################################################
#
#   以下、メイン処理
#
###############################################################################

if __name__ == "__main__":
    app = ShrinkMovie()
    app.run()