import os
import tkinter as tk
import tkinter.filedialog as fd
from docx import Document

def ask_input_filenames(msg = None, types = [('', '*.*')]):
	"""
			入力用ファイル名の設定
	"""
	rt = tk.Tk()
	rt.withdraw()
	filenames = fd.askopenfilenames(title = msg, filetypes = types)
	rt.destroy()
	return filenames


def ask_output_filename(filename, msg = None, types = [('', '*.*')], deftype = '.txt'):
	"""
			出力用ファイル名の設定
	"""
	rt = tk.Tk()
	rt.withdraw()
	filename = fd.asksaveasfilename(initialfile = filename, title = msg, filetypes = types, defaultextension = deftype)
	rt.destroy()
	return filename


# ファイルを選択する（複数可）
input_filenames = ask_input_filenames('入力データファイル', types = [('Wordファイル(*.docx)', '*.docx')])
# キャンセルされた場合
if input_filenames == '':
	print('キャンセルされました。何かキーを押してください。')
	input()
	exit()

# 選択したファイル全てで著者情報を削除していく
for input_filename in input_filenames:

    try:
    	doc = Document(input_filename)
    except:
    	print(f'ファイル{input_filename}でエラーが起こりました。ファイルに問題があります。\n何かキーを押してください。')
    	input()
    	continue

    core_properties = doc.core_properties
    meta_fields= ["author", "category", "last_modified_by", "comments", "content_status", "identifier", "keywords", "language", "subject", "title", "version"]
    for meta_field in meta_fields:
        setattr(core_properties, meta_field, "")

    initial_filename = os.path.basename(input_filename)
    initial_filename = initial_filename[:-5] + '(著者情報削除済).docx'
    output_filename = ask_output_filename(initial_filename, msg = '出力ファイル', types = [('テキスト (*.docx)', '*.docx')])
    # キャンセルされた場合
    if output_filename == '':
    	#print('キャンセルされました。何かキーを押してください。')
    	#input()
    	continue

    doc.save(output_filename)

